function get_tasks(){
  let tasks = JSON.parse(localStorage.getItem("tasks"));
  if(tasks){

    let list_html = "";
    tasks.forEach(function(item, i){ // [{}, {}]

      list_html += `
        <li data-id="${item.item_id}">
          <div class="item_flex">
            <div class="middle_block">
              <p class="para">${item.name}</p>
              <input type="text" class="task_name_update -none" placeholder="更新待辦事項…" value="${item.name}">
            </div>
            <div class="right_block">
              <div class="btn_flex">
                <button type="button" class="btn_update">更新</button>
                <button type="button" class="btn_delete">移除</button>
              </div>
            </div>
          </div>
        </li>
      `;

    });
    let ul_task_list = document.getElementsByClassName("task_list")[0];
    ul_task_list.innerHTML = list_html;

  }

}

document.addEventListener("DOMContentLoaded", function(){

  // ******************* 從 localStorage 取得資料 ******************* //
  get_tasks();

  // ==== 待辦事項文字框的 focus 事件及 blur 事件觸發 ===== //
  var input_task_name = document.getElementsByClassName("task_name")[0];

  input_task_name.addEventListener("focus", function(){
    this.closest("div.task_add_block").classList.add("-on");
  });
  input_task_name.addEventListener("blur", function(){
    this.closest("div.task_add_block").classList.remove("-on");
  });


  // ==== text 欄位新增待辦事項 ===== //
  input_task_name.addEventListener("keyup", function(e){
    //console.log( e.which );
    if(e.which == 13){
      let button_task_add = document.getElementsByClassName("task_add")[0];
      button_task_add.click();
    }
  });

  // 按下新增按鈕
  var button_task_add = document.getElementsByClassName("task_add")[0];
  button_task_add.addEventListener("click", function(){
    let task_text = (input_task_name.value).trim();

    if(task_text != ""){

      let item_id = Date.now(); // timestamp 當做該項的 id

      let list_html = `
        <li data-id="${item_id}">
          <div class="item_flex">
            <div class="middle_block">
              <p class="para">` + task_text + `</p>
              <input type="text" class="task_name_update -none" placeholder="更新待辦事項…" value="${task_text}">
            </div>
            <div class="right_block">
              <div class="btn_flex">
                <button type="button" class="btn_update">更新</button>
                <button type="button" class="btn_delete">移除</button>
              </div>
            </div>
          </div>
        </li>
      `;

      let ul_task_list = document.getElementsByClassName("task_list")[0];
      ul_task_list.insertAdjacentHTML("afterbegin", list_html);
      input_task_name.value = "";


      // ******************* 儲存資料到 localStorage ******************* //
      let task = {
        "item_id": item_id,
        "name": task_text
      };
      let tasks = JSON.parse(localStorage.getItem("tasks"));
      //console.log(tasks);

      if(tasks){ // 若存在
        tasks.unshift(task); // [{}, {}]
      }else{ // 若不存在
        tasks = [task];
      }
      localStorage.setItem("tasks", JSON.stringify(tasks));

    }

  });
});


// ==== 移除待辦事項 ===== //
document.addEventListener("click", function(e){
  //console.log(e.target);
  
  if(e.target.classList.contains("btn_delete")){
    let r = confirm("確認移除？");
    if (r){

      // ******************* 從 localStorage 移除資料 ******************* //
      let item_id = e.target.closest("li").getAttribute("data-id");
      let tasks = JSON.parse(localStorage.getItem("tasks"));
      tasks.forEach(function(task, i){
        if(item_id == task.item_id){
          tasks.splice(i, 1);
        }
      });
      localStorage.setItem("tasks", JSON.stringify(tasks));

      e.target.closest("li").classList.add("fade_out");
      setTimeout(function(){
        e.target.closest("li").remove();
      }, 1000);
    }

  }
});

// ==== 清空待辦事項 ===== //
var button_btn_empty = document.getElementsByClassName("btn_empty")[0];
button_btn_empty.addEventListener("click", function(){
  let r = confirm("確認清空？")
  if (r){

    // ******************* 從 localStorage 移除資料 ******************* //
    localStorage.clear();


    let ul_task_list = document.getElementsByClassName("task_list")[0];
    for(let i = 0; i < ul_task_list.children.length; i++){
      ul_task_list.children[i].classList.add("fade_out");
    }
    setTimeout(function(){
      ul_task_list.innerHTML = "";
    }, 1000);

  }
});

// ==== 更新待辦事項 ===== //
document.addEventListener("click", function(e){
  if(e.target.classList.contains("btn_update")){

    let the_p = e.target.closest("li").querySelector("p.para");
    let the_task_name_update = e.target.closest("li").querySelector("input.task_name_update");

    if( e.target.getAttribute("data-edit") == undefined){ // 進入編輯狀態

      e.target.setAttribute("data-edit", "true");
      the_p.classList.toggle("-none");
      the_task_name_update.classList.toggle("-none");

    }else{
      let update_task_name = (the_task_name_update.value).trim();
      if(update_task_name == ""){
        alert("請輸入待辦事項");
      }else{
        the_p.innerHTML = update_task_name;
        the_p.classList.toggle("-none");
        the_task_name_update.value = update_task_name;
        the_task_name_update.classList.toggle("-none");

        e.target.removeAttribute("data-edit");

        // ******************* 更新 localStorage 中，name 的資料 ******************* //
        let item_id = e.target.closest("li").getAttribute("data-id");
        let tasks = JSON.parse(localStorage.getItem("tasks"));
        tasks.forEach(function(task, i){
          if(item_id == task.item_id){
            tasks[i].name = update_task_name;
          }
        });
        localStorage.setItem("tasks", JSON.stringify(tasks));
      }
    }

  }
});